this.name        = "Quantum Drive System";
this.author      = "Switeck";
this.licence        = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0";
this.copyright      = "(C) 2011 Switeck";
this.description = "Galactic Hyperdrive destination changer.";
this.version     = "0.2.3 - for Oolite 1.75 and later";

"use strict";

this.activated = function()
{
	if(player.ship.galacticHyperspaceBehaviour == "BEHAVIOUR_FIXED_COORDINATES") {
		player.commsMessage("Gal. Hyperdrive was set to Selected destination: "+player.ship.galacticHyperspaceFixedCoords,6);
	} else {
		player.commsMessage("Gal. Hyperdrive was set: "+player.ship.galacticHyperspaceBehaviour,6);
	}
	if(player.ship.equipmentStatus("EQ_QUANTUM_DRIVE") == "EQUIPMENT_OK") {
		if(player.ship.equipmentStatus("EQ_GAL_DRIVE") == "EQUIPMENT_OK") {
			if(missionVariables.quantumDrive > 3 || missionVariables.quantumDrive == null) missionVariables.quantumDrive = 0;
			missionVariables.quantumDrive++;
			if(missionVariables.quantumDrive == 1) {
				player.ship.galacticHyperspaceBehaviour = "BEHAVIOUR_STANDARD";
				player.commsMessage("Gal. Hyperdrive - Default mode, only reachable systems are possible destinations!",6);
			}
			if(missionVariables.quantumDrive == 2) {
				player.ship.galacticHyperspaceBehaviour = "BEHAVIOUR_ALL_SYSTEMS_REACHABLE";
				player.commsMessage("Gal. Hyperdrive - ALL systems Reachable!",6);
			}
			if(missionVariables.quantumDrive == 3) {
				player.ship.galacticHyperspaceBehaviour = "BEHAVIOUR_FIXED_COORDINATES";
				player.ship.galacticHyperspaceFixedCoords = [ 96, 96, 0]; // old coords format?	([ 96, 96, 0]);
//				player.ship.galacticHyperspaceFixedCoords = ([16, 255, 0]); // Oresrati, G8.
				player.commsMessage("Gal. Hyperdrive - Go to Galaxy center (96, 96).",6);
			}
			if(missionVariables.quantumDrive == 4) {
				player.ship.galacticHyperspaceBehaviour = "BEHAVIOUR_FIXED_COORDINATES";
				player.ship.galacticHyperspaceFixedCoords = [ player.ship.cursorCoordinates.x, player.ship.cursorCoordinates.y, 0];
//				player.commsMessage("Gal. Hyperdrive - Selected destination mode.",6);
				player.commsMessage("Gal. Hyperdrive - Selected destination: "+player.ship.galacticHyperspaceFixedCoords,6);
			}
//			player.commsMessage("Gal. Hyperdrive mode: "+player.ship.galacticHyperspaceBehaviour+" destination: "+player.ship.galacticHyperspaceFixedCoords,6);
		} else player.commsMessage("Galactic Hyperdrive missing or damaged!",6);
	} else player.commsMessage("Quantum Drive damaged!",6);
}